/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class cBank {
    private ArrayList<cKonto> kundenKonto;
    private int anzahl;

    public cBank() {
        try {
            FileReader Lesen = new FileReader("Bankkunden.txt");
            BufferedReader ein = new BufferedReader(Lesen);
            this.kundenKonto = new ArrayList();
            this.anzahl = Integer.parseInt(ein.readLine());
            for (int i = 0; i < this.anzahl; ++i) {
                int kontoNummer = Integer.parseInt(ein.readLine());
                String typ = ein.readLine();
                String name = ein.readLine();
                double kontoStand = Double.parseDouble(ein.readLine());
                if (typ.equals("Giro")) {
                    this.kundenKonto.add(new cGirokonto(name, kontoNummer, kontoStand));
                    continue;
                }
                this.kundenKonto.add(new cSparkonto(name, kontoNummer, kontoStand));
            }
            ein.close();
        }
        catch (IOException e) {
            System.err.println("Datei exisitiert nicht!");
        }
    }

    public void datenSichern() {
        try {
            FileWriter Schreiben = new FileWriter("Bankkunden.txt");
            PrintWriter aus = new PrintWriter(Schreiben);
            aus.println(this.kundenKonto.size());
            for (cKonto konto : this.kundenKonto) {
                aus.println(konto.getKontoNummer());
                aus.println(konto.getKontoTyp());
                aus.println(konto.getInhaber());
                aus.println(konto.getKontoStand_sicher(4711));
            }
            aus.close();
        }
        catch (IOException e) {
            System.err.println("Fehler beim Erstellen der Datei!");
        }
    }

    public int kontoSuche(int nummer) {
        boolean erfolg = false;
        for (int i = 0; i < this.anzahl && !erfolg; ++i) {
            cKonto konto = this.kundenKonto.get(i);
            if (konto.getKontoNummer() != nummer) continue;
            erfolg = true;
            return i;
        }
        return -1;
    }

    public void einzahlen(int nummer, double betrag) {
        int index = this.kontoSuche(nummer);
        if (index != -1) {
            cKonto konto = this.kundenKonto.get(index);
            konto.einzahlen(betrag);
        }
    }

    public void abheben(int nummer, double betrag, int code) {
        int index = this.kontoSuche(nummer);
        if (index != -1) {
            cKonto konto = this.kundenKonto.get(index);
            konto.abheben(betrag, code);
        }
    }

    public void ueberweisen(int quelle, int ziel, double betrag, int code) {
        int index1 = this.kontoSuche(quelle);
        int index2 = this.kontoSuche(ziel);
        if (index1 != -1 && index2 != -1) {
            String typ2;
            cKonto konto1 = this.kundenKonto.get(index1);
            cKonto konto2 = this.kundenKonto.get(index2);
            String typ1 = konto1.getKontoTyp();
            if (typ1.equals(typ2 = konto2.getKontoTyp())) {
                konto1.ueberweisen(konto2, betrag, code);
            } else {
                System.err.println("Fehler!");
            }
        } else {
            System.err.println("Fehler!");
        }
    }

    public double getKontoStand(int nummer, int code) {
        int index = this.kontoSuche(nummer);
        if (index != -1) {
            cKonto konto = this.kundenKonto.get(index);
            return konto.getKontoStand(code);
        }
        return -1.0;
    }

    public String getInhaber(int nummer) {
        int index = this.kontoSuche(nummer);
        if (index != -1) {
            cKonto konto = this.kundenKonto.get(index);
            return konto.getInhaber();
        }
        return null;
    }

    public String getTyp(int nummer) {
        int index = this.kontoSuche(nummer);
        if (index != -1) {
            cKonto konto = this.kundenKonto.get(index);
            return konto.getKontoTyp();
        }
        return null;
    }

    public void neuerKunde(int kontoNummer, String name, double kontoStand, String typ) {
        if (typ.equals("Giro")) {
            this.kundenKonto.add(new cGirokonto(name, kontoNummer, kontoStand));
            ++this.anzahl;
        } else if (typ.equals("Spar")) {
            this.kundenKonto.add(new cSparkonto(name, kontoNummer, kontoStand));
            ++this.anzahl;
        }
        this.datenSichern();
    }
}

