 import java.awt.BasicStroke;
 import java.awt.Color;
 import java.awt.Frame;
 import java.awt.Graphics;
 import java.awt.Graphics2D;
 import java.awt.Image;
 import java.awt.event.MouseAdapter;
 import java.awt.event.MouseEvent;
 import java.awt.event.WindowAdapter;
 import java.awt.event.WindowEvent;
 import javax.imageio.ImageIO;
 
public class GUI extends Frame {
  private Image dbImage;
  private Graphics dbGraphics;
  private GUIThread guiThread;
  private boolean[] lampen = hardware.getOutputs();
  private boolean[] inputs = hardware.getInputs();
  private int[] lampenX = new int[] { 143, 143, 120, 102, 84, 143, 143, 191, 205, 201, 201, 201, 369, 355, 417, 417, 441, 459, 477, 417, 417, 369, 355, 360, 360, 360, 191, 205, 77, 515 };
  private int[] lampenY = new int[] { 335, 321, 324, 324, 324, 157, 169, 139, 139, 116, 98, 80, 139, 139, 157, 169, 166, 166, 166, 333, 321, 350, 350, 374, 392, 410, 350, 350, 70, 70 };
  private int[] inputsX = new int[] { 105, 105, 158, 359, 436, 436, 382, 181, 103, 242, 448, 310, 310, 242 };
  private int[] inputsY = new int[] { 347, 146, 101, 101, 123, 324, 370, 370, 275, 99, 207, 382, 275, 207 };
  
  
  public GUI(String title, GUIThread guiThread) {
    super(title);
    this.guiThread = guiThread;
    
    addWindowListener(new WindowAdapter()
    {      
      public void windowClosing(WindowEvent event)
      {
        GUI.this.setVisible(false);
        GUI.this.dispose();
      }
    });
     
    addMouseListener(new MouseAdapter()
    {
      public void mousePressed(MouseEvent e)
      {
        for (int i = 0; i < GUI.this.lampenX.length; i++) {
          toggle(e, GUI.this.lampenX[i], GUI.this.lampenY[i], i + 1);
        }
      }
      
      
      public void toggle(MouseEvent e, int x, int y, int nummer) {
        if (e.getX() > x && e.getX() < x + 10 && e.getY() > y && e.getY() < y + 10) {
          if (!GUI.this.lampen[nummer - 1]) {
            hardware.ledOn(nummer);
          } else {
            
            hardware.ledOff(nummer);
          } 
        }
      }
    });
    setSize(572, 480);
    setResizable(false);
    setVisible(true);
  }
  
  public void abfragen() {
    while (true) {
      this.lampen = hardware.getOutputs();
      this.inputs = hardware.getInputs();
      repaint();
      
      try {
        Thread.sleep(10L);
      }
      catch (Exception e) {}
    } 
  }

  public void update(Graphics g) {
    if (this.dbImage == null) {
      this.dbImage = createImage((getSize()).width, (getSize()).height);
      this.dbGraphics = this.dbImage.getGraphics();
    } 

    Image img = null;
    try {
      img = ImageIO.read(getClass().getResource("crossroads.jpg"));
    } catch (Exception e) {}
    this.dbGraphics.drawImage(img, 3, 25, this);
    
    this.dbGraphics.setColor(getForeground());
    paint(this.dbGraphics);
    
    g.drawImage(this.dbImage, 0, 0, this);
  }
  
  
  public void paint(Graphics g) {
    g.setColor(new Color(7, 51, 2)); int i;
    for (i = 0; i < 28; i++) {
      
      if (!this.lampen[i]) {
        g.fillOval(this.lampenX[i], this.lampenY[i], 11, 11);
      }
    } 
    
    if (!this.lampen[28]) {
      g.setColor(Color.black);
      g.fillOval(this.lampenX[28], this.lampenY[28], 11, 11);
    } 
    
    if (!this.lampen[29]) {
      g.setColor(new Color(7, 51, 2));
      g.fillOval(this.lampenX[29], this.lampenY[29], 11, 11);
    } 
    
    
    for (i = 0; i < 8; i++) {
      if (this.inputs[i]) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(5.0F));
        g2.setColor(Color.yellow);
        g2.drawRect(this.inputsX[i], this.inputsY[i], 30, 30);
      } 
    } 
    
    
    for (i = 8; i < 14; i++) {
      if (this.inputs[i]) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(3.0F));
        g2.setColor(Color.red);
        g2.drawOval(this.inputsX[i], this.inputsY[i], 20, 20);
      } 
    } 
   
    int helligkeit = hardware.getLight();
    g.setColor(Color.black);
    g.drawString(String.valueOf(helligkeit), 454, 80);
  }
}


/* Location:              D:\Umleitung\Desktop\Eduline\eduLine.jar!\GUI.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       1.1.3
 */