import java.lang.reflect.Method;

public class LoopThread extends Thread  {
  private Object objekt;
  private Method methode;
  private String methodenname;
  private int millisekunden;
  private volatile Thread t;
  
  public LoopThread(Object objekt, Method methode, String methodenname, int millisekunden) {
    this.methode = methode;
    this.objekt = objekt;
    this.methodenname = methodenname;
    this.millisekunden = millisekunden;
    this.t = this;
  }

  
  public void run() {
    Thread thisThread = Thread.currentThread();
    while (this.t == thisThread) {
      try {
        this.methode.invoke(this.objekt, new Object[0]);
        if (this.millisekunden != 0) {
          hardware.pause(this.millisekunden);
        }
      }
      catch (Exception e) {
        System.out.println(e);
      } 
    } 
  }

  public void stopp() {
    this.t = null;
  }

  
  public String getMethodenname() {
    return this.methodenname;
  }
  
  public Object getObjekt(){
    return this.objekt;
  }
}
