package eduLine;

public class eduJava    {
  private final int jeError = -536870911;
  private final int jePollInterval = 12;
  private final int notOpen = 999;

  private int iHandle = 999;

  private boolean notHalt = true;

  static {
    try {
      System.loadLibrary("eduline");
      System.loadLibrary("umFish40");
      System.loadLibrary("eduJava");
    }
    catch (Exception e) {
      System.err.println("DLL-Dateien eduline.dll, umFish40.dll und eduJava.dll konnten nicht geladen werden!");
    } 
  }

  public enum Out    {
    IF1O0,
    IF1O1, IF1O2, IF1O3, IF1O4, IF1O5, IF1O6, IF1O7, IF1O8,
    EM1O1, EM1O2, EM1O3, EM1O4, EM1O5, EM1O6, EM1O7, EM1O8,
    EM2O1, EM2O2, EM2O3, EM2O4, EM2O5, EM2O6, EM2O7, EM2O8,
    EM3O1, EM3O2, EM3O3, EM3O4, EM3O5, EM3O6, EM3O7, EM3O8;
  }

  public enum Inp     {
    IF1I0,
    IF1I1, IF1I2, IF1I3, IF1I4, IF1I5, IF1I6, IF1I7, IF1I8,
    EM1I1, EM1I2, EM1I3, EM1I4, EM1I5, EM1I6, EM1I7, EM1I8;
  }

  public enum Dir    {
    Off, On;
  }

  public class DeviceData     {
    public String Name;
    public int Type;
    public int SerialNr;
    public String Firmware;
  }

  public class CrossRoadsException
  extends RuntimeException {
    public static final long serialVersionUID = -536870911L;

    public CrossRoadsException() {}

    public CrossRoadsException(String message) {
      super(message);
    }
  }

  public class IFTypen    {
    public static final int first_USB = 0;

    public static final int ROBO_Interface_USB = 60;

    public static final int EDU_LINE_Module = 300;

    public static final int EDU_LINE_CrossRoads = 301;
    public static final int EDU_LINE_TrafficLights = 302;
    public static final int EDU_LINE_Signal = 303;
  }

  public class OutM     {
    public static final int IF1O1 = 1;
    public static final int IF1O2 = 2;
    public static final int IF1O3 = 4;
    public static final int IF1O4 = 8;
    public static final int IF1O5 = 16;
    public static final int IF1O6 = 32;
    public static final int IF1O7 = 64;
    public static final int IF1O8 = 128;
    public static final int EM1O1 = 256;
    public static final int EM1O2 = 512;
    public static final int EM1O3 = 1024;
    public static final int EM1O4 = 2048;
    public static final int EM1O5 = 4096;
    public static final int EM1O6 = 8192;
    public static final int EM1O7 = 16384;
    public static final int EM1O8 = 32768;
    public static final int EM2O1 = 65536;
    public static final int EM2O2 = 131072;
    public static final int EM2O3 = 196608;
    public static final int EM2O4 = 262144;
    public static final int EM2O5 = 1048576;
    public static final int EM2O6 = 2097152;
    public static final int EM2O7 = 4194304;
    public static final int EM2O8 = 8388608;
    public static final int EM3O1 = 16777216;
    public static final int EM3O2 = 33554432;
    public static final int EM3O3 = 67108864;
    public static final int EM3O4 = 134217728;
    public static final int EM3O5 = 268435456;
    public static final int EM3O6 = 536870912;
    public static final int EM3O7 = 1073741824;
    public static final int EM3O8 = -2147483648;
  }

  public DeviceData getActDevice() {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.getActDevice"); 
    DeviceData dd = new DeviceData();
    dd.Name = "EDU_LINE";
    dd.Type = jeGetActDeviceType(this.iHandle);
    dd.SerialNr = jeGetActDeviceSerialNr(this.iHandle);
    int f = jeGetActDeviceFirmwareNr(this.iHandle);
    dd.Firmware = String.format("%d.%d.%d.%d", new Object[] { Integer.valueOf((f & 0xFF000000) >> 24), Integer.valueOf((f & 0xFF0000) >> 16), Integer.valueOf((f & 0xFF00) >> 8), Integer.valueOf(f & 0xFF) });

    
    return dd;
  }

  public void clearOutputs() {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.clearOutputs"); 
    int res = jeSetOutputs(this.iHandle, 0);
    if (res == -536870911) {
      throw new CrossRoadsException("DeviceProblem.clearOutputs");
    }
  }

  public void closeUSB() {
    if (this.iHandle == 999) {
      throw new CrossRoadsException("DeviceProblem.closeUSB");
    }
    jeCloseUSB(this.iHandle);

    this.iHandle = 999;
  }

  public boolean finish() {
    Thread.yield();
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.finish"); 
    if (this.notHalt || escape() != 0)
      return true; 
    if (jeGetInputs(this.iHandle) == -536870911)
      throw new CrossRoadsException("DeviceProblem.finish"); 
    return false;
  }

  public boolean getInput(Inp inputNr) {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.getInput"); 
    int res = jeGetInput(this.iHandle, inputNr.ordinal());
    if (res == -536870911)
      throw new CrossRoadsException("DeviceProblem.getInput"); 
    return (res == 1);
  }

  public int getInputs() {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.getInputs"); 
    int res = jeGetInputs(this.iHandle);
    if (res == -536870911)
      throw new CrossRoadsException("DeviceProblem.getInputs"); 
    return res;
  }

  public int getVoltage() {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.getVoltage"); 
    int res = jeGetVoltage(this.iHandle, 1);
    if (res == -536870911)
      throw new CrossRoadsException("DeviceProblem.getVoltage"); 
    return res;
  }

  public boolean getNotHalt() {
    return this.notHalt;
  }

  public void setNotHalt(boolean OnOff) {
    this.notHalt = OnOff;
  }

  public void openUSB() {
    openUSB(0, 0);
  }

  public void openUSB(int ifTyp, int serialNr) {
    this.iHandle = jeOpenUSB(ifTyp, serialNr);
    if (this.iHandle == -536870911)
      throw new CrossRoadsException("DeviceProblem.openUSB"); 
    jeSetOutputs(this.iHandle, 0);
    this.notHalt = false;
  }

  public boolean getOpenStatus() {
    return !(this.iHandle == 999);
  }

  public int getOutputs() {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.getOutputs"); 
    int res = jeGetOutputs(this.iHandle);
    if (res == -536870911)
      throw new CrossRoadsException("DeviceProblem.getOutputs"); 
    return res;
  }

  public void pause(int mSek) {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.Pause"); 
    int sZeit = getTickCount();
    do {
      Thread.yield();
      if (this.notHalt || escape() != 0)
        return; 
      if (jeGetInputs(this.iHandle) == -536870911)
        throw new CrossRoadsException("DeviceProblem.pause");  
      try { Thread.sleep(12L); } catch (InterruptedException ei) {}
    } while (getTickCount() - sZeit < mSek);
  }

  public void setOutput(Out outputNr, Dir onOff) {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.setOutput"); 
    if (jeSetOutput(this.iHandle, outputNr.ordinal(), onOff.ordinal()) == -536870911) {
      throw new CrossRoadsException("DeviceProblem.setOutput");
    }
  }

  public void setOutputs(int status) {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.setOutputss"); 
    if (jeSetOutputs(this.iHandle, status) == -536870911) {
      throw new CrossRoadsException("DeviceProblem.setOutputs");
    }
  }

  public void waitForInput(Inp inputNr) {
    waitForInput(inputNr, true);
  }

  public void waitForInput(Inp inputNr, boolean onOff) {
    if (this.iHandle == 999)
      throw new CrossRoadsException("KeinOpen.waitForInput"); 
    do {
      if (this.notHalt || escape() != 0)
        return; 
      if (jeGetInputs(this.iHandle) == -536870911)
        throw new CrossRoadsException("DeviceProblem.waitForInput");  
      try { Thread.sleep(12L); } catch (InterruptedException ei) {}
    } while ((!getInput(inputNr)) == onOff);
  }

  public String Version() {
    return "2.09.00.01";
  }

  public void waitForLow(Inp inputNr) {
    waitForInput(inputNr, true);
    waitForInput(inputNr, false);
  }

  public void waitForHigh(Inp inputNr) {
    waitForInput(inputNr, false);
    waitForInput(inputNr, true);
  }

  public native int jeOpenUSB(int paramInt1, int paramInt2);

  public native int jeCloseUSB(int paramInt);

  public native int jeGetInput(int paramInt1, int paramInt2);

  public native int jeGetInputs(int paramInt);

  public native int jeGetVoltage(int paramInt1, int paramInt2);

  public native int jeGetOutputs(int paramInt);

  public native int jeSetOutputs(int paramInt1, int paramInt2);

  public native int jeSetOutput(int paramInt1, int paramInt2, int paramInt3);

  public native int jeGetActDeviceType(int paramInt);

  public native int jeGetActDeviceSerialNr(int paramInt);

  public native int jeGetActDeviceFirmwareNr(int paramInt);

  public native int escape();

  public native int getTickCount();

  public native void Sleep(int paramInt);
}

/* Location:              D:\Umleitung\Desktop\Eduline\eduLine.jar!\eduLine\eduJava.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       1.1.3
 */