import eduLine.eduJava;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;

public final class hardware   {
  private static hardware h;
  private static eduJava cr;
  private static SensorThread sensorThread;
  private static ArrayList<LoopThread> loopThreadListe = new ArrayList<>();
  private static long startZeit;

  private hardware() {
    ClassLoader cl = getClass().getClassLoader();
    URL url = cl.getResource("eduLine");
    String pfad = url.toString();

    try {
      pfad = pfad.replace("+", "%2B");
      pfad = URLDecoder.decode(pfad, "UTF-8");
    }
    catch (Exception e) {
      System.err.println("Der Pfad zum BlueJ-Projekt enthält evtl. Sonderzeichen!");
      System.exit(0);
    } 

    if (pfad.startsWith("jar")) {
      pfad = pfad.replace("jar:", "");
      if (pfad.startsWith("file://")) {
        pfad = pfad.replace("file:", "");
      } else {
        pfad = pfad.replace("file:/", "");
      } 
      pfad = pfad.replace("eduLine.jar!/eduLine", "");
    } else {
      pfad = pfad.replace("file:/", "");
      pfad = pfad.replace("/eduLine", "/+libs");
    } 

    try {
      setJavaLibraryPath(pfad);
    }
    catch (Exception e) {
      System.err.println("Setzen des Java-Library-Path fehlgeschlagen!");
      System.exit(0);
    } 

    if (!System.getProperty("os.arch").equals("x86")) {
      System.err.println("Keine x86-Version der Java JDK!");
      System.exit(0);
    } else {
      cr = new eduJava();
      cr.openUSB();
    } 

    sensorThread = new SensorThread();
    sensorThread.start();
    startZeit = -1L;
  }

  private void setJavaLibraryPath(String path) throws NoSuchFieldException, IllegalAccessException {
    String newPath = path + File.pathSeparator + System.getProperty("java.library.path");
    System.setProperty("java.library.path", newPath);
    Field field = ClassLoader.class.getDeclaredField("sys_paths");
    if (field != null) {
      field.setAccessible(true);
      field.set(System.class.getClassLoader(), (Object)null);
    } 
  }

  private static synchronized hardware getHardware() {
    if (h == null) {
      h = new hardware();
    }
    return h;
  }

  private static eduJava.Out mapAusgang(int ausgang) {
    eduJava.Out out;
    switch (ausgang) { 
      case 1: out = eduJava.Out.EM2O1; return out;
      case 2: out = eduJava.Out.EM2O2; return out;
      case 3: out = eduJava.Out.IF1O1; return out;
      case 4: out = eduJava.Out.IF1O2; return out;
      case 5: out = eduJava.Out.IF1O3; return out;
      case 6: out = eduJava.Out.EM3O1; return out;
      case 7: out = eduJava.Out.EM3O2; return out;
      case 8: out = eduJava.Out.EM2O7; return out;
      case 9: out = eduJava.Out.EM2O8; return out;
      case 10: out = eduJava.Out.EM1O4; return out;
      case 11: out = eduJava.Out.EM1O5; return out;
      case 12: out = eduJava.Out.EM1O6; return out;
      case 13: out = eduJava.Out.EM3O7; return out;
      case 14: out = eduJava.Out.EM3O8; return out;
      case 15: out = eduJava.Out.EM2O3; return out;
      case 16: out = eduJava.Out.EM2O4; return out;
      case 17: out = eduJava.Out.IF1O4; return out;
      case 18: out = eduJava.Out.IF1O5; return out;
      case 19: out = eduJava.Out.IF1O6; return out;
      case 20: out = eduJava.Out.EM3O3; return out;
      case 21: out = eduJava.Out.EM3O4; return out;
      case 22: out = eduJava.Out.EM2O5; return out;
      case 23: out = eduJava.Out.EM2O6; return out;
      case 24: out = eduJava.Out.EM1O1; return out;
      case 25: out = eduJava.Out.EM1O2; return out;
      case 26: out = eduJava.Out.EM1O3; return out;
      case 27: out = eduJava.Out.EM3O5; return out;
      case 28: out = eduJava.Out.EM3O6; return out;
      case 29: out = eduJava.Out.EM1O8; return out;
      case 30: out = eduJava.Out.EM1O7; return out;
    }  
    out = null;
    return out;
  }

  public static void ledOn(int ausgang) {
    eduJava.Out out = mapAusgang(ausgang);
    if (out != null) {
      getHardware(); cr.setOutput(out, eduJava.Dir.On);
    } else {
      System.out.println("keine LED an Ausgang " + ausgang);
    } 
  }

  public static void ledOff(int ausgang) {
    eduJava.Out out = mapAusgang(ausgang);
    if (out != null) {
      getHardware(); cr.setOutput(out, eduJava.Dir.Off);
    } else {
      System.out.println("keine LED an Ausgang " + ausgang);
    } 
  }

  public static void pause(int milliSekunden) {
    getHardware(); cr.pause(milliSekunden);
  }

  public static int getLight() {
    getHardware(); return cr.getVoltage();
  }

  public static boolean isPressed(int eingang) {
    eduJava.Inp in;
    switch (eingang) { 
      case 1:
      in = eduJava.Inp.IF1I1;
      break;
      case 2:
      in = eduJava.Inp.IF1I2;
      break;
      case 3:
      in = eduJava.Inp.IF1I7;
      break;
      case 4:
      in = eduJava.Inp.IF1I8;
      break;
      case 5:
      in = eduJava.Inp.IF1I3;
      break;
      case 6:
      in = eduJava.Inp.IF1I4;
      break;
      case 7:
      in = eduJava.Inp.IF1I5;
      break;
      case 8:
      in = eduJava.Inp.IF1I6;
      break;
      default:
      in = null;
      break; }

    if (in != null) {
      getHardware(); 
      return cr.getInput(in);
    } 

    System.out.println("kein Taster mit der Nummer " + eingang + " vorhanden");
    return false;
  }

  public static boolean wasPressed(int nummer) {
    if (nummer >= 1 && nummer <= 8) {
      boolean status = sensorThread.getTaster()[nummer - 1];
      sensorThread.resetTaster(nummer - 1);
      return status;
    } 

    System.out.println("kein Taster mit der Nummer " + nummer + " vorhanden");
    return false;
  }

  public static boolean isContacted(int eingang) {
    eduJava.Inp in;
    switch (eingang) { 
      case 1:
      in = eduJava.Inp.EM1I1;
      break;
      case 2:
      in = eduJava.Inp.EM1I4;
      break;
      case 3:
      in = eduJava.Inp.EM1I2;
      break;
      case 4:
      in = eduJava.Inp.EM1I3;
      break;
      case 5:
      in = eduJava.Inp.EM1I5;
      break;
      case 6:
      in = eduJava.Inp.EM1I6;
      break;
      default:
      in = null;
      break; 
    }

    if (in != null) {
      getHardware(); 
      return cr.getInput(in);
    } 

    System.err.println("kein Magnetsensor mit der Nummer " + eingang + " vorhanden");
    return false;
  }

  public static void loop(Object objekt, String methodenname) {
    loopWithDelay(objekt, methodenname, 0);
  }

  public static void loopWithDelay(Object objekt, String methodenname, int millisekunden) {
    Method methode = null;

    try {
      methode = objekt.getClass().getMethod(methodenname, new Class[0]);
    }
    catch (Exception e) {}

    if (methode != null) {
      LoopThread st = new LoopThread(objekt, methode, methodenname, millisekunden);
      st.start();
      loopThreadListe.add(st);
    } else {

      System.out.println("Methode " + methodenname + " nicht vorhanden");
    } 
  }

  public static void stopLoop(int index) {
    if (index < loopThreadListe.size() && index >= 0) {
      ((LoopThread)loopThreadListe.get(index)).stopp();
      loopThreadListe.remove(index);
    } else {

      System.out.println("keine laufende Methode (loop) mit dem Index " + index + " vorhanden");
    } 
  }

  public static void stopLoopId(int index) { 
    int stelle = -1;
    if (loopThreadListe.size() > 0) {
      for (int i = 0; i < loopThreadListe.size(); i++) {
        if (((LoopThread)loopThreadListe.get(i)).getId() == index) {
          stelle = i;
        }
      } 
    }
    if (stelle != -1) {
      ((LoopThread)loopThreadListe.get(index)).stopp();
      loopThreadListe.remove(index);
    } else {

      System.out.println("keine laufende Methode (loop) mit dem Index " + index + " vorhanden");
    } 

  }

  public static void stopLoop(Object objekt, String methodenname){
    int index = -1;
    if (loopThreadListe.size() > 0) {
      for (int i = 0; i < loopThreadListe.size(); i++) {
        if (((LoopThread)loopThreadListe.get(i)).getMethodenname().equals(methodenname) && ((LoopThread)loopThreadListe.get(i)).getObjekt().equals(objekt)) {
          index = i;
        }
      } 
    }
    if (index != -1) {
      ((LoopThread)loopThreadListe.get(index)).stopp();
      loopThreadListe.remove(index);
    } else {

      System.out.println("keine laufende Methode (loop) mit dem Namen " + methodenname + " vorhanden");
    } 
  }

  public static void stopLoop(String methodenname) {
    int index = -1;
    if (loopThreadListe.size() > 0) {
      for (int i = 0; i < loopThreadListe.size(); i++) {
        if (((LoopThread)loopThreadListe.get(i)).getMethodenname().equals(methodenname)) {
          index = i;
        }
      } 
    }
    if (index != -1) {
      ((LoopThread)loopThreadListe.get(index)).stopp();
      loopThreadListe.remove(index);
    } else {

      System.out.println("keine laufende Methode (loop) mit dem Namen " + methodenname + " vorhanden");
    } 
  }

  public static void stopAllLoops() {
    if (loopThreadListe.size() > 0) {
      for (int i = 0; i < loopThreadListe.size(); i++) {
        ((LoopThread)loopThreadListe.get(i)).stopp();
        loopThreadListe.remove(i);
      } 
    }else {

      System.out.println("keine laufenden Methoden (loops) vorhanden");
    } 
  }

  public static void listLoops() {
    if (loopThreadListe.size() > 0) {
      System.out.println(".\tName\tID:");
      System.out.println("-------------------------------------");
      for (int i = 0; i < loopThreadListe.size(); i++) {
        System.out.println(i + "\t" + ((LoopThread)loopThreadListe.get(i)).getMethodenname() + "\t" + ((LoopThread)loopThreadListe.get(i)).getId());
      }
    } else {
      System.out.println("keine laufenden Methoden (loops) vorhanden");
    } 
  }

  public static void allOutputsOff() {
    for (int i = 1; i <= 30; i++) {
      ledOff(i);
    }
  }

  public static void showStatus() {
    GUIThread g = new GUIThread();
    g.start();
  }

  public static void startClock() {
    startZeit = System.nanoTime();
  }

  public static long stopClock() {
    if (startZeit != -1L) {
      return (System.nanoTime() - startZeit) / 1000000L;
    }
    System.out.println("die Stoppuhr wurde nicht gestartet!");
    return 0L;
  }

  public static boolean[] getOutputs() {
    getHardware(); int outputsInt = cr.getOutputs();
    String outputString = Integer.toBinaryString(outputsInt);

    while (outputString.length() < 32) {
      outputString = "0" + outputString;
    }

    boolean[] outputsArray = new boolean[32];
    for (int i = 0; i < 32; i++) {
      if (outputString.charAt(i) == '0') {
        outputsArray[i] = false;
      } else {
        outputsArray[i] = true;
      } 
    } 

    boolean[] outputs = new boolean[30];
    outputs[0] = outputsArray[15];
    outputs[1] = outputsArray[14];
    outputs[2] = outputsArray[31];
    outputs[3] = outputsArray[30];
    outputs[4] = outputsArray[29];
    outputs[5] = outputsArray[7];
    outputs[6] = outputsArray[6];
    outputs[7] = outputsArray[9];
    outputs[8] = outputsArray[8];
    outputs[9] = outputsArray[20];
    outputs[10] = outputsArray[19];
    outputs[11] = outputsArray[18];
    outputs[12] = outputsArray[1];
    outputs[13] = outputsArray[0];
    outputs[14] = outputsArray[13];
    outputs[15] = outputsArray[12];
    outputs[16] = outputsArray[28];
    outputs[17] = outputsArray[27];
    outputs[18] = outputsArray[26];
    outputs[19] = outputsArray[5];
    outputs[20] = outputsArray[4];
    outputs[21] = outputsArray[11];
    outputs[22] = outputsArray[10];
    outputs[23] = outputsArray[23];
    outputs[24] = outputsArray[22];
    outputs[25] = outputsArray[21];
    outputs[26] = outputsArray[3];
    outputs[27] = outputsArray[2];
    outputs[28] = outputsArray[16];
    outputs[29] = outputsArray[17];

    return outputs;
  }

  public static boolean getOutput(int nummer) {
    if (nummer < 1 || nummer > 30) {
      System.err.println("keine LED an Ausgang " + nummer);
      return false;
    } 

    return getOutputs()[nummer - 1];
  }

  public static boolean[] getInputs() {
    getHardware(); 
    int inputsInt = cr.getInputs();
    String inputString = Integer.toBinaryString(inputsInt);
    while (inputString.length() < 16) {
      inputString = "0" + inputString;
    }

    boolean[] inputsArray = new boolean[16];
    for (int i = 0; i < 16; i++) {
      if (inputString.charAt(i) == '0') {
        inputsArray[i] = false;
      } else {

        inputsArray[i] = true;
      } 
    } 

    boolean[] inputs = new boolean[14];
    inputs[0] = inputsArray[15];    
    inputs[1] = inputsArray[14];   
    inputs[2] = inputsArray[9];     
    inputs[3] = inputsArray[8];     
    inputs[4] = inputsArray[13];    
    inputs[5] = inputsArray[12];    
    inputs[6] = inputsArray[11];    
    inputs[7] = inputsArray[10];    
    inputs[8] = inputsArray[7];     
    inputs[9] = inputsArray[4];     
    inputs[10] = inputsArray[6];    
    inputs[11] = inputsArray[5];    
    inputs[12] = inputsArray[3];    
    inputs[13] = inputsArray[2];

    return inputs;
  }

  public static void blinken(){
    ledOn(1);
    pause(200);
    ledOff(1);
    pause(200);
  }

  public static void close() {
    sensorThread.stopp();
    cr.closeUSB();
    System.exit(0);
  }

  public static eduJava debug() {
    System.out.println("java.library.path=" + System.getProperty("java.library.path"));
    return cr;
  }
}
