import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.TitledBorder;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 28.10.2024
 * @author 
 */

public class GUI2 extends JFrame {
  // Anfang Attribute
  private Hauptprogramm modell;
  private JLabel lAnalysevonSortierverfahren = new JLabel();
  private JPanel jBGVerfahren = new JPanel();
  private JComboBox<String> jElemente = new JComboBox<>();
  private DefaultComboBoxModel<String> jElementeModel = new DefaultComboBoxModel<>();
  private JLabel lElemente = new JLabel();
  private JPanel jBGArt = new JPanel();
  private JButton bListeerzeugen = new JButton();
  private JButton bListesortieren = new JButton();
  private JLabel lAuswertung = new JLabel();
  private JLabel lVergleiche = new JLabel();
  private JTextField jTFVergleiche = new JTextField();
  private JLabel lVertauschungen = new JLabel();
  private JTextField jTFVertauschungen = new JTextField();
  private JLabel lZeitinms = new JLabel();
  private JTextField jTFZeit = new JTextField();
  private JButton bEnde = new JButton();
  private JList<String> jListevorher = new JList<>();
  private DefaultListModel<String> jListevorherModel = new DefaultListModel<>();
  private JScrollPane jListevorherScrollPane = new JScrollPane(jListevorher);
  private JList<String> jListedanach = new JList<>();
  private DefaultListModel<String> jListedanachModel = new DefaultListModel<>();
  private JScrollPane jListedanachScrollPane = new JScrollPane(jListedanach);
    private ButtonGroup jBGArtBG = new ButtonGroup();
    private TitledBorder jBGArtTB = new TitledBorder("Struktur");
    private JRadioButton jBGArtRB0 = new JRadioButton("aufsteigend sortierte Liste");
    private JRadioButton jBGArtRB1 = new JRadioButton("absteigend sortierte Liste");
    private JRadioButton jBGArtRB2 = new JRadioButton("Zufallsliste");
    private ButtonGroup jBGVerfahrenBG = new ButtonGroup();
    private TitledBorder jBGVerfahrenTB = new TitledBorder("Verfahren");
    private JRadioButton jBGVerfahrenRB0 = new JRadioButton("Ripplesort");
    private JRadioButton jBGVerfahrenRB1 = new JRadioButton("Bubblesort I");
    private JRadioButton jBGVerfahrenRB2 = new JRadioButton("Bubblesort II");
    private JRadioButton jBGVerfahrenRB3 = new JRadioButton("Insertsort");
    private JRadioButton jBGVerfahrenRB4 = new JRadioButton("Selectsort");
    private JRadioButton jBGVerfahrenRB5 = new JRadioButton("Mergesort");
    private JRadioButton jBGVerfahrenRB6 = new JRadioButton("Permsort");
    private JRadioButton jBGVerfahrenRB7 = new JRadioButton("Xsort");
    private JRadioButton jBGVerfahrenRB8 = new JRadioButton("Ysort");
  // Ende Attribute
  
  
  public GUI2() { 
    // Frame init
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 740; 
    int frameHeight = 457;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Sortieralgorithmen");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    lAnalysevonSortierverfahren.setBounds(8, 8, 430, 40);
    lAnalysevonSortierverfahren.setText("Analyse von Sortierverfahren");
    lAnalysevonSortierverfahren.setFont(new Font("Dialog", Font.BOLD, 26));
    cp.add(lAnalysevonSortierverfahren);
    jBGVerfahren.setLayout(null);
    jBGVerfahren.setBounds(16, 56, 208, 184);
    jBGVerfahrenRB0.setBounds(6, 17, 196, 19);
    jBGVerfahrenRB0.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB0);
    jBGVerfahren.add(jBGVerfahrenRB0);
    jBGVerfahrenRB1.setBounds(6, 36, 196, 19);
    jBGVerfahrenRB1.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB1);
    jBGVerfahren.add(jBGVerfahrenRB1);
    jBGVerfahrenRB2.setBounds(6, 54, 196, 18);
    jBGVerfahrenRB2.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB2);
    jBGVerfahren.add(jBGVerfahrenRB2);
    jBGVerfahrenRB3.setBounds(6, 72, 196, 18);
    jBGVerfahrenRB3.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB3);
    jBGVerfahren.add(jBGVerfahrenRB3);
    jBGVerfahrenRB4.setBounds(6, 90, 196, 18);
    jBGVerfahrenRB4.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB4);
    jBGVerfahren.add(jBGVerfahrenRB4);
    jBGVerfahrenRB5.setBounds(6, 108, 196, 18);
    jBGVerfahrenRB5.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB5);
    jBGVerfahren.add(jBGVerfahrenRB5);
    jBGVerfahrenRB6.setBounds(6, 126, 196, 18);
    jBGVerfahrenRB6.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB6);
    jBGVerfahren.add(jBGVerfahrenRB6);
    jBGVerfahrenRB7.setBounds(6, 144, 196, 18);
    jBGVerfahrenRB7.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB7);
    jBGVerfahren.add(jBGVerfahrenRB7);
    jBGVerfahrenRB8.setBounds(6, 162, 196, 18);
    jBGVerfahrenRB8.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGVerfahrenBG.add(jBGVerfahrenRB8);
    jBGVerfahren.add(jBGVerfahrenRB8);
    jBGVerfahren.setBorder(jBGVerfahrenTB);
    jBGVerfahrenTB.setTitleFont(new Font("Dialog", Font.BOLD, 11));
    cp.add(jBGVerfahren);
    jElemente.setModel(jElementeModel);
    jElemente.setFont(new Font("Dialog", Font.BOLD, 11));
    jElemente.setBounds(24, 264, 200, 24);
    jElementeModel.addElement("10");
    jElementeModel.addElement("20");
    jElementeModel.addElement("50");
    jElementeModel.addElement("100");
    jElementeModel.addElement("200");
    jElementeModel.addElement("500");
    jElementeModel.addElement("1000");
    jElementeModel.addElement("2000");
    jElementeModel.addElement("5000");
    jElementeModel.addElement("10000");
    jElementeModel.addElement("20000");
    jElementeModel.addElement("50000");
    jElementeModel.addElement("100000");
    jElementeModel.addElement("200000");
    jElementeModel.addElement("500000");
    jElementeModel.addElement("1000000");
    jElementeModel.addElement("2000000");
    jElementeModel.addElement("5000000");
    jElementeModel.addElement("");
    jElemente.setEditable(true);
    cp.add(jElemente);
    lElemente.setBounds(16, 248, 80, 16);
    lElemente.setFont(new Font("Dialog", Font.BOLD, 11));
    lElemente.setText("Elemente");
    cp.add(lElemente);
    jBGArt.setLayout(null);
    jBGArt.setBounds(16, 304, 208, 88);
    jBGArtRB0.setBounds(6, 17, 196, 23);
    jBGArtRB0.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGArtBG.add(jBGArtRB0);
    jBGArt.add(jBGArtRB0);
    jBGArtRB1.setBounds(6, 40, 196, 23);
    jBGArtRB1.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGArtBG.add(jBGArtRB1);
    jBGArt.add(jBGArtRB1);
    jBGArtRB2.setBounds(6, 62, 196, 22);
    jBGArtRB2.setFont(new Font("Dialog", Font.BOLD, 11));
    jBGArtBG.add(jBGArtRB2);
    jBGArt.add(jBGArtRB2);
    jBGArt.setBorder(jBGArtTB);
    jBGArtTB.setTitleFont(new Font("Dialog", Font.BOLD, 11));
    cp.add(jBGArt);
    bListeerzeugen.setBounds(264, 56, 105, 49);
    bListeerzeugen.setFont(new Font("Dialog", Font.BOLD, 11));
    bListeerzeugen.setText("Liste erzeugen");
    bListeerzeugen.setMargin(new Insets(2, 2, 2, 2));
    bListeerzeugen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bListeerzeugen_ActionPerformed(evt);
      }
    });
    cp.add(bListeerzeugen);
    bListesortieren.setBounds(416, 56, 104, 49);
    bListesortieren.setFont(new Font("Dialog", Font.BOLD, 11));
    bListesortieren.setText("Liste sortieren");
    bListesortieren.setMargin(new Insets(2, 2, 2, 2));
    bListesortieren.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bListesortieren_ActionPerformed(evt);
      }
    });
    cp.add(bListesortieren);
    lAuswertung.setBounds(560, 56, 80, 24);
    lAuswertung.setFont(new Font("Dialog", Font.BOLD, 11));
    lAuswertung.setText("Auswertung");
    cp.add(lAuswertung);
    lVergleiche.setBounds(560, 88, 126, 18);
    lVergleiche.setText("Vergleiche");
    lVergleiche.setFont(new Font("Dialog", Font.PLAIN, 11));
    cp.add(lVergleiche);
    jTFVergleiche.setBounds(560, 104, 144, 25);
    jTFVergleiche.setFont(new Font("Dialog", Font.PLAIN, 11));
    jTFVergleiche.setText("");
    cp.add(jTFVergleiche);
    lVertauschungen.setBounds(560, 144, 158, 18);
    lVertauschungen.setText("Vertauschungen");
    lVertauschungen.setFont(new Font("Dialog", Font.PLAIN, 11));
    cp.add(lVertauschungen);
    jTFVertauschungen.setBounds(560, 160, 144, 25);
    jTFVertauschungen.setFont(new Font("Dialog", Font.PLAIN, 11));
    cp.add(jTFVertauschungen);
    lZeitinms.setBounds(560, 200, 145, 16);
    lZeitinms.setText("Zeit in ms");
    lZeitinms.setFont(new Font("Dialog", Font.PLAIN, 11));
    cp.add(lZeitinms);
    jTFZeit.setBounds(560, 216, 145, 24);
    jTFZeit.setFont(new Font("Dialog", Font.PLAIN, 11));
    cp.add(jTFZeit);
    bEnde.setBounds(560, 352, 144, 41);
    bEnde.setFont(new Font("Dialog", Font.BOLD, 11));
    bEnde.setText("Ende");
    bEnde.setMargin(new Insets(2, 2, 2, 2));
    bEnde.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bEnde_ActionPerformed(evt);
      }
    });
    cp.add(bEnde);
    jListevorher.setModel(jListevorherModel);
    jListevorherScrollPane.setBounds(264, 112, 105, 280);
    jListevorher.setFont(new Font("Dialog", Font.BOLD, 11));
    jListevorherModel.addElement("");
    cp.add(jListevorherScrollPane);
    jListedanach.setModel(jListedanachModel);
    jListedanachScrollPane.setBounds(416, 112, 104, 280);
    jListedanach.setFont(new Font("Dialog", Font.BOLD, 11));
    jListedanachModel.addElement("");
    cp.add(jListedanachScrollPane);
    // Ende Komponenten
    
    setVisible(true);
    jBGVerfahrenRB0.setSelected(true);
    jBGArtRB1.setSelected(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new GUI2();
    
  }
  public void bListeerzeugen_ActionPerformed(ActionEvent evt) {
   
    jListevorherModel.clear();
    jListedanachModel.clear();
    int elemente = Integer.parseInt(jElemente.getSelectedItem().toString());
    String verfahren = this.jBGVerfahrenBG_getSelectedButtonGroupLabel();
    String struktur = this.jBGArtBG_getSelectedButtonGroupLabel();
    modell = new Hauptprogramm(verfahren,elemente, struktur);
    for (Integer i: modell.getListe()){
      jListevorherModel.addElement(String.valueOf(i));
    }
    bListesortieren.setVisible(true);
    bListeerzeugen.setVisible(false);
  }

  public void bListesortieren_ActionPerformed(ActionEvent evt) {
    modell.sortieren();
    for (Integer i: modell.getListe()){
      jListedanachModel.addElement(String.valueOf(i));
    }
    jTFVergleiche.setText(String.valueOf(modell.getVergleiche()));
    jTFVertauschungen.setText(String.valueOf(modell.getVertauschungen()));
    jTFZeit.setText(String.valueOf(modell.getZeit()));
    bListesortieren.setVisible(false);
    bListeerzeugen.setVisible(true);
    
  }

  public void bEnde_ActionPerformed(ActionEvent evt) {
    System.exit(0);
    
  }

  public String jBGArtBG_getSelectedButtonGroupLabel() {
    for (java.util.Enumeration<AbstractButton> e = jBGArtBG.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public String jBGVerfahrenBG_getSelectedButtonGroupLabel() {
    for (java.util.Enumeration<AbstractButton> e = jBGVerfahrenBG.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  // Ende Methoden
}
