/** Beschreibung der abstrakten Klasse Sortierer:
 *  abstrakte Klasse zur Realisierung von Sortierverfahren
 * @author  T. Hempel
 * @version 2023-06-17
 */
import java.util.*;
public abstract class Sortierer{

  protected int listenlaenge;
  protected ArrayList<Integer> liste;
  protected long vergleiche;
  protected long vertauschungen;
  protected long messzeit;

  /**
   * Konstruktor zur Initialisierung aller Werte
   * @param pLaenge Listenlänge
   */
  public Sortierer(int pLaenge)    {
    listenlaenge = pLaenge;
    liste = new ArrayList<Integer>();
    for (int i = 0; i < listenlaenge; i++)    {
      liste.add(0);
    }
    vergleiche = 0;
    vertauschungen = 0;
    messzeit = 0;
  }

  /**
   * Methode zum Erzeugen einer zufällig geordneten Liste
   */
  public void erzeugeZufallsliste()  {
    liste.clear();
    for (int i = 0; i < listenlaenge; i++)    {
      liste.add((int) (listenlaenge*Math.random()));
    }
  }

  /**
   * Methode zum Erzeugen einer absteigend sortierten Liste
   */
  public void erzeugeReverseListe()  {
    liste.clear();
    for (int i = listenlaenge - 1; i >= 0; i--)    {
      liste.add(i);
    }
  }

  /**
   * Methode zum Erzeugen einer aufsteigend sortierten Liste
   */
  public void erzeugeSortierteListe()  {
    liste.clear();
    for (int i = 0; i < listenlaenge; i++)    {
      liste.add(i);
    }
  }

  /**
   * Methode zur Ausgabe der Liste auf der Console
   * Ausgabe nur bei Listelaengen mit max. 100 Elementen
   */
  public void druckeListeAufConsole(){
    if (listenlaenge <= 100){
      for (int i = 0; i < listenlaenge; i++)    {
        System.out.println(String.valueOf(liste.get(i)));
      } 
    }
  }
  
  /**
   * Ausgabe der Ergebnisse auf der Konsole
   */
  public void zeigeAuswertung(long pMesszeit){
    System.out.println("-----------------------------------------");
    System.out.println("Elementeanzahl: " + listenlaenge);
    System.out.println("Zeit in ms    : " + pMesszeit);
    System.out.println("Vergleiche    : " + vergleiche);
    System.out.println("Vertauschungen: " + vertauschungen);
  }

  /**
   * Abstrakte Methode, die in den Subklassen gefüllt wird
   */
  public abstract void sortiereZufallsliste();

  public ArrayList<Integer> getListe(){
    return liste;
  }
  
  public long getVergleiche(){
    return vergleiche;
  }
  
  public long getTausche(){
    return vergleiche;
  }
  
  public long getZeit(){
    return messzeit;
    }
} // Ende der abstrakten Klasse Sortierer

